#include "mode1/erdiagram/AttributesRect.h"
#include "mode1/erdiagram/Table.h"
#include "mode1/erdiagram/NameRect.h"
#include "mode1/erdiagram/PrimaryKeysRect.h"
#include "mode1/erdiagram/Attribute.h"

AttributesRect::AttributesRect(QRectF& rect, QGraphicsItem * parent) : QGraphicsRectItem(parent)
{
	double gap = ((Table*)(this->parentItem()))->GetPrimaryRect()->boundingRect().height();
	gap += ((Table*)(this->parentItem()))->GetNameRect()->boundingRect().height();
	QRectF rectOfThis(rect.x()+1, rect.y()+1+gap, rect.width()-2, (rect.height()-2)/3);

	this->setRect(rectOfThis);

	this->rect = rectOfThis;

	QRectF rectf = this->boundingRect();
	Attribute* attribute = new Attribute(rectf, this->attributes.count(), "Attribute1", this);

	this->attributes << attribute;
}

void AttributesRect::SetPosition(int length)
{
	if( length == 1 ){
		this->rect = QRectF(this->boundingRect().x(), this->boundingRect().y()+16, 
			this->boundingRect().width(), this->boundingRect().height());
	}
	else if( length == 0 ){
		this->rect = QRectF(this->boundingRect().x(), this->boundingRect().y()-16, 
			this->boundingRect().width(), this->boundingRect().height());
	}

	this->setRect(this->rect);

	for(int i=0; i < (this->attributes.count()); i++){
		(this->attributes)[i]->SetPosition(length);
	}
}

AttributesRect::~AttributesRect()
{
}

void AttributesRect::InsertAttribute()
{
	QString buffer("Attribute");
	QString number;
	number.sprintf("%d", (this->attributes.count()+1));
	buffer = buffer + number;

	QRectF rect = this->boundingRect();

	Attribute* attribute = new Attribute(rect, this->attributes.count(), buffer, this);

	this->attributes << attribute;

	((Table*)(this->parentItem()))->ReSize();
}

void AttributesRect::InsertAttribute(QString name)
{
	QRectF rect = this->boundingRect();

	Attribute* attribute = new Attribute(rect, this->attributes.count(), name, this);

	this->attributes << attribute;

	((Table*)(this->parentItem()))->ReSize();
}

void AttributesRect::InsertAttribute(QStringList &list)
{
	for( int i=0; i<list.count(); i++){

		QRectF rect = this->boundingRect();
		Attribute* attribute = new Attribute(rect, this->attributes.count(), list[i], this);
		
		this->attributes << attribute;
	}	
	//((Table*)(this->parentItem()))->GetAttributesRect()->SetPosition(1);
	((Table*)(this->parentItem()))->ReSize();	
}

void AttributesRect::DeleteAttribute()
{
	Attribute* buffer;

	if( this->attributes.count() == 1 ){
		this->attributes.last()->setPlainText("");
	}
	
	else if( this->attributes.count() > 1 ){
		buffer = this->attributes.takeLast();
		
		delete buffer;

		this->SetRect(0);
	}
}

void AttributesRect::DeleteAttribute(QStringList& foreignKeyList, QList<Attribute*>& list)
{
	for( int i=0; i<this->attributes.count(); i++){
		
		for(int j=0; j< foreignKeyList.count(); j++){
			
			if( foreignKeyList[j].contains("(FK)", Qt::CaseInsensitive) == false ){
				foreignKeyList[j] = foreignKeyList[j] + "(FK)";
			}
			
			if( (this->attributes)[i]->toPlainText() == foreignKeyList[j] ){
				list << this->attributes.takeAt(i);
			}
		}
	}
}

void AttributesRect::DeleteAttribute(Attribute* attribute)
{
	int i=0;

	while( i<this->attributes.count() && ((this->attributes)[i]->pos() != attribute->pos())){
		i++;
	}

	Attribute* buffer = 0;

	if( i < this->attributes.count() ){
		buffer = (this->attributes).takeAt(i);
	}

	if ( buffer != 0 ){
		delete buffer;
	}
}

void AttributesRect::SetRect(int state)
{
	double buffer = 16;		//  ũ⸦ ø offset

	if( state == 0 ){
		buffer = -buffer;
	}

	this->rect = QRectF(this->boundingRect().x(), this->boundingRect().y(), 
		this->boundingRect().width(), this->boundingRect().height() + buffer);
	this->setRect(rect);

	((Table*)(this->parentItem()))->GetAttributesRect()->SetPosition(state);
	((Table*)(this->parentItem()))->SetPosition(state);
}
